ORCA/M Asm65816 2.1.0

0001 2CEE                       title 'Menu Mgr Patch        GS ROM 3 Patch' 
0002 2CEE              ******************************************************************
0003 2CEE              *
0004 2CEE              *                   Menu manager patches for ROM 3
0005 2CEE              *
0006 2CEE              * System Disk 5.0
0007 2CEE              *
0008 2CEE              *
0009 2CEE              * 21 May 89         Steven Glass
0010 2CEE              *
0011 2CEE              * The picture control defproc was not doing the right thing.
0012 2CEE              * on dispose.  Any picture loaded from a resource was not
0013 2CEE              * released.
0014 2CEE              *
0015 2CEE              * 31 May 89         Harry Yee
0016 2CEE              *
0017 2CEE              * Take out prototype bit in version number.
0018 2CEE              *
0019 2CEE              * 31 Aug 89         Harry Yee
0020 2CEE              *
0021 2CEE              * Fix static text control bug (BRC #51450) Init routine was not
0022 2CEE              * copying the justification field into the control record. 
0023 2CEE              *
0024 2CEE              * 26-Nov-90         Dave Lyons
0025 2CEE              *
0026 2CEE              * Rolled version to $8303.
0027 2CEE              * Changed CMUnloadSegments to BRK (used on ROM 1 only).
0028 2CEE              * NewControl patch: See if CreateList is creating a list control.
0029 2CEE              *   If it is, replace the ROM defproc $FCF0E9 with the real one, as
0030 2CEE              *   returned from GetListDefProc.
0031 2CEE              *
0032 2CEE              * 4-Jan-91          Dave Lyons
0033 2CEE              *
0034 2CEE              * Removed my obsolete NewControl patch (was used when CreateList
0035 2CEE              * calls NewControl from ROM, but I've discarded the ROM 3 List
0036 2CEE              * Manager).
0037 2CEE              *
0038 2CEE              * Patched Draw message to scroll bar defproc (old and extended)
0039 2CEE              * to check for a default color table and change it to my new one,
0040 2CEE              * which gets modified at CtlNewRes time based on the MasterSCB.
0041 2CEE              *
0042 2CEE              * Patched CtlNewRes to modify the new default scroll bar color
0043 2CEE              * table.
0044 2CEE              *
0045 2CEE              * Patched NewValue message to scroll bar defproc (old and
0046 2CEE              * extended) so it waits until it's been minScrollTicks ticks
0047 2CEE              * since the last time we set a scroll bar value--this maxes
0048 2CEE              * out the scrolling speed at something reasonable, even if
0049 2CEE              * folks have souped-up machines.
0050 2CEE              *
0051 2CEE              * 6-Jan-91          Dave Lyons
0052 2CEE              *
0053 2CEE              * Changed scroll bar delay thing to use WaitUntil (misc tools).
0054 2CEE              *
0055 2CEE              * 9-Jan-91          Dave Lyons
0056 2CEE              *
0057 2CEE              * Patched HiliteControl(xxx,0) so unhiliting the most-recently-
0058 2CEE              * hilited control waits until it's been 4 ticks since the hilite,
0059 2CEE              * using WaitUntil.
0060 2CEE              *
0061 2CEE              * 19-Jan-91         Dave Lyons
0062 2CEE              *
0063 2CEE              * Added three new function (linked in from TOOL016):
0064 2CEE              *   $3903 FindRadioButton
0065 2CEE              *   $3A03 SetLETextByID
0066 2CEE              *   $3B03 GetLETextByID
0067 2CEE              *
0068 2CEE              * 5-Apr-91          Dave Lyons
0069 2CEE              *
0070 2CEE              * Link in the whole StatTextProc from Control Manager; kill the
0071 2CEE              * weird patching stuff.  (New feature in the RAM-based StatTextProc
0072 2CEE              * is the draw-fast bit.)
0073 2CEE              *
0074 2CEE              * 8-Apr-91          Dave Lyons
0075 2CEE              *
0076 2CEE              * Added a missing BRA NotThisOne from LLToolboxVector.  Was making
0077 2CEE              * picture controls crash.
0078 2CEE              *
0079 2CEE              * 16-Apr-91         Dave Lyons
0080 2CEE              *
0081 2CEE              * Patched SendEventToCtl to ignore invisible controls.
0082 2CEE              *
0083 2CEE              * 22-Aug-91         Dave Lyons
0084 2CEE              *
0085 2CEE              * Patched MakeNextCtlTarget to allow cycling backwards.
0086 2CEE              *
0087 2CEE              * 15-Sep-91         Dave Lyons
0088 2CEE              *
0089 2CEE              * Pull in new CMLoadResource from ControlMgr.  New version
0090 2CEE              * sets SysPrefs to prompt for disk & never have a cancel button.
0091 2CEE              *
0092 2CEE              * 4-Dec-91          Dave Lyons
0093 2CEE              *
0094 2CEE              * CMLoadResource now clears the supress-one-button-dialogs SysPrefs
0095 2CEE              * bit, so the OS doesn't infinite-loop looking for the disk (imported
0096 2CEE              * from Tool016).
0097 2CEE              *
0098 2CEE              * 8-Dec-91          Dave Lyons
0099 2CEE              *
0100 2CEE              * Fixed LLToolboxVector to use linked-in RAM-based scroll_proc for
0101 2CEE              * all scroll bar stuff, instead of special-casing everything...this
0102 2CEE              * was becoming far too much of a pain.
0103 2CEE              *
0104 2CEE              * 9-Dec-91          Dave Lyons
0105 2CEE              *
0106 2CEE              * CtlNewRes calls ComputeScrollColor in ControlMgr:ControlMgr.asm.
0107 2CEE              * This cool new code calls RefreshDesktop if the scroll pattern
0108 2CEE              * changes.
0109 2CEE              *
0110 2CEE              * 15-Jan-92         Dave Lyons
0111 2CEE              *
0112 2CEE              * Linked in CtlShutDown from ControlMgr:ControlMgr.asm, so we can
0113 2CEE              * remove the refreshDeskTask from the Run Queue.
0114 2CEE              *
0115 2CEE              * 5-Feb-92          Dave Lyons
0116 2CEE              *
0117 2CEE              * Version $0303 for 6.0 final.
0118 2CEE              *
0119 2CEE              ******************************************************************
0120 2CEE              *
0121 2CEE              * 3-Jun-92          Dave Lyons
0122 2CEE              *
0123 2CEE              * Changed version to $8304 for 6.0.1d5.
0124 2CEE              *
0125 2CEE              * Made CtlStartUp remove the RefreshDesktop run queue routine, to
0126 2CEE              * avoid redrawing everything once when starting an application in
0127 2CEE              * a different resolution.
0128 2CEE              *
0129 2CEE              * 15-Jul-92         Dave Lyons
0130 2CEE              *
0131 2CEE              * Suck in new calls from ControlMgr.asm:
0132 2CEE              *   SetCtlValueByID
0133 2CEE              *   GetCtlValueByID
0134 2CEE              *   InvalOneCtlByID
0135 2CEE              *   HiliteCtlByID
0136 2CEE              *
0137 2CEE              * 2-Apr-93 DAL
0138 2CEE              *
0139 2CEE              * Version $0304 for 6.0.1
0140 2CEE              *
0141 2CEE              **********************************************************************
0142 2CEE
0143 2CEE              ****************************************************************
0144 2CEE              *                                                              *
0145 2CEE              *              Copyright Apple Computer, Inc. 1989-92          *
0146 2CEE              *                     All Rights Reserved                      *
0147 2CEE              *                                                              *
0148 2CEE              ****************************************************************
0149 2CEE                       Blanks off 
0150 2CEE                       String asis 
0151 2CEE
0152 2CEE                       include 'all.macros' 
0153 2CEE
0154 2CEE                       include ':::ControlMgr:equates.asm' 
0155 2CEE                       include ':::ControlMgr:superEquates.asm' 
0156 2CEE                       include ':::sys.equs.asm' 
0157 2CEE
0158 2CEE              CtlVersionNum equ $0304                 ;2-Apr-93 DAL
0159 2CEE
0160 2CEE              ;-----------------------------------------------------------
0161 2CEE              ;
0162 2CEE              ; Stack Fram Equates for control
0163 2CEE              ;
0164 2CEE                       DefineStack 
0165 2CEE              OrigD    WORD                           ; caller's saved direct page register
0166 2CEE              OrigB    byte                           ; caller's saved data bank register
0167 2CEE              TheCtlPtr LONG                          ; pointer to control record
0168 2CEE              RtnAddr  block 3                        ; RTL address back to Control Manager
0169 2CEE              theCtlHandle LONG                       ; handle to control record
0170 2CEE              CtlParam LONG                           ; add'l parameter passed to DefProc
0171 2CEE              CtlCode  WORD                           ; operation to perform
0172 2CEE              ReturnValue LONG                        ; space for return value to Ctl Mgr.
0173 2CEE
0174 2CEE
0175 2CEE
0176 2CEE              ;====================================================================
0177 2CEE              ;
0178 2CEE              ;          Control Manager Function Table.
0179 2CEE              ;
0180 2CEE              ;====================================================================
0181 2CEE              ControlCallTable PROC EXPORT 
0182 2CEE                       import CtlVersion 
0183 2CEE                       import CtlBootInit 
0184 2CEE                       import NewControl2 
0185 2CEE                       import CtlNewRes               ;4-Jan-91 DAL
0186 2CEE                       import CtlStartUp              ;4-Jan-91 DAL
0187 2CEE                       import HiliteControl           ;9-Jan-91 DAL
0188 2CEE                       import FindRadioButton         ;19-Jan-91 DAL
0189 2CEE                       import SetLETextByID           ;19-Jan-91 DAL
0190 2CEE                       import GetLETextByID           ;19-Jan-91 DAL
0191 2CEE                       import SendEventToCtl          ;16-Apr-91 DAL
0192 2CEE                       import MakeNextControlActive   ;22-Aug-91 DAL
0193 2CEE                       import CMLoadResource          ;15-Sep-91 DAL
0194 2CEE                       import CtlShutDown             ;15-Jan-92 DAL
0195 2CEE                       import SetCtlValueByID         ;15-Jul-92 DAL
0196 2CEE                       import GetCtlValueByID         ;15-Jul-92 DAL
0197 2CEE                       import InvalOneCtlByID         ;15-Jul-92 DAL
0198 2CEE                       import HiliteCtlByID           ;15-Jul-92 DAL
0199 2CEE
0200 2CEE 40 00 00 00  FPT      DC L:(ENDFPT-FPT)/4
0201 2CF2 BA 32 02 00           DC L:CtlBootInit-1                                     ;1
0202 2CF6 F7 30 02 00           DC L:CtlStartup-1                                      ;2
0203 2CFA C0 33 02 00           DC L:CtlShutDown-1                                     ;3 (patched 15-Jan-92 DAL)
0204 2CFE ED 30 02 00           DC L:CtlVersion-1                                      ;4
0205 2D02 00 00 00 00           DC L:0                         ; CtlReset-1                    ;Shutdown, called from WindShutDown.
0206 2D06 00 00 00 00           DC L:0                         ; CtlStatus-1           ;6
0207 2D0A 00 00 00 00           DC L:0                         ; Reserved-1            ;7
0208 2D0E 00 00 00 00           DC L:0                         ; Reserved-1            ;8
0209 2D12 00 00 00 00           DC L:0                         ; NewControl-1          ;9
0210 2D16 00 00 00 00           DC L:0                         ; DisposeControl-1      ;A
0211 2D1A 00 00 00 00           DC L:0                         ; KillControls-1        ;B
0212 2D1E 00 00 00 00           DC L:0                         ; SetCtlTitle-1         ;C
0213 2D22 00 00 00 00           DC L:0                         ; GetCtlTitle-1         ;D
0214 2D26 00 00 00 00           DC L:0                         ; HideControl-1         ;E
0215 2D2A 00 00 00 00           DC L:0                         ; ShowControl-1         ;F
0216 2D2E 00 00 00 00           DC L:0                         ; DrawControls-1        ;10
0217 2D32 06 31 02 00           DC L:HiliteControl-1                                   ;11 patched 9-Jan-91 DAL
0218 2D36 4D 31 02 00           DC L:CtlNewRes-1                                       ;12
0219 2D3A 00 00 00 00           DC L:0                         ; FindControl-1         ;13
0220 2D3E 00 00 00 00           DC L:0                         ; TestControl-1         ;14
0221 2D42 00 00 00 00           DC L:0                         ; TrackControl-         ;15
0222 2D46 00 00 00 00           DC L:0                         ; MoveControl-1         ;16
0223 2D4A 00 00 00 00           DC L:0                         ; DragControl-1         ;17
0224 2D4E 00 00 00 00           DC L:0                         ; SetCtlIcons-1         ;18
0225 2D52 00 00 00 00           DC L:0                         ; SetCtlValue-1         ;19
0226 2D56 00 00 00 00           DC L:0                         ; GetCtlValue-1         ;1A
0227 2D5A 00 00 00 00           DC L:0                         ; SetCtlParam-1         ;1B
0228 2D5E 00 00 00 00           DC L:0                         ; GetCtlParam-1         ;1C
0229 2D62 00 00 00 00           DC L:0                         ; WindDragRect-1                ;Address may be patched by CtlStartup.
0230 2D66 00 00 00 00           DC L:0                         ; GrowSize-1            ;1E
0231 2D6A 00 00 00 00           DC L:0                         ; GetCtlzpage-1         ;1F
0232 2D6E 00 00 00 00           DC L:0                         ; SetCtlAction-1        ;20
0233 2D72 00 00 00 00           DC L:0                         ; GetCtlAction-1        ;21
0234 2D76 00 00 00 00           DC L:0                         ; SetCtlRefCon-1        ;22
0235 2D7A 00 00 00 00           DC L:0                         ; GetCtlRefCon-1        ;23
0236 2D7E 00 00 00 00           DC L:0                         ; EraseControl-1        ;24
0237 2D82 00 00 00 00           DC L:0                         ; DrawOneCtl-1          ;25
0238 2D86 00 00 00 00           DC L:0                         ; FindActiveControl-1   ;$26
0239 2D8A DA 31 02 00           DC L:MakeNextControlActive-1                           ;$27 patched 22-Aug-91 DAL
0240 2D8E 00 00 00 00           DC L:0                         ; MakeThisCtlActive-1   ;$28
0241 2D92 58 31 02 00           DC L:SendEventToCtl-1                                  ;$29 patched 16-Apr-91 DAL
0242 2D96 00 00 00 00           DC L:0                         ; GetCtlID-1            ;$2A
0243 2D9A 00 00 00 00           DC L:0                         ; SetCtlID-1            ;$2B
0244 2D9E 00 00 00 00           DC L:0                         ; CallDefProc-1         ;$2C  (added oct 3 88)
0245 2DA2 00 00 00 00           DC L:0                         ; NotifyControls-1      ;$2D  (added oct 3 88)
0246 2DA6 00 00 00 00           DC L:0                         ; GetCtlMoreFlags-1     ;$2E
0247 2DAA 00 00 00 00           DC L:0                         ; SetCtlMoreFlags-1     ;$2F
0248 2DAE 00 00 00 00           DC L:0                         ; GetHandleFromID-1     ;$30
0249 2DB2 74 32 02 00           DC L:NewControl2-1             ;                       ;$31
0250 2DB6 A1 35 02 00           DC L:CMLoadResource-1                                  ;$32 patched 15-Sep-91 DAL
0251 2DBA 00 00 00 00           DC L:0                         ; CMReleaseResource-1   ;$33  (added Oct 12 88)
0252 2DBE 00 00 00 00           DC L:0                         ; SetCtlParamPtr-1      ;$34  (added Oct 21 88)
0253 2DC2 00 00 00 00           DC L:0                         ; GetCtlParamPtr-1      ;$35  (added Oct 21 88)
0254 2DC6 00 00 00 00           DC L:0                         ; FutzCtls-1            ;$36  (added Mar 28 89)
0255 2DCA 00 00 00 00           DC L:0                         ; InvalCtls-1           ;$37  (added Nov 9 88)
0256 2DCE
0257 2DCE 00 00 FC 00           DC L:$fc0001-1                 ; CMUnloadSegments-1    ;$38  (unused on ROM 3; make it BRK. DAL)
0258 2DD2              *** 6.0
0259 2DD2 D2 33 02 00           DC L:FindRadioButton-1                                 ;$39 added 19-Jan-91 DAL for 6.0
0260 2DD6 7A 34 02 00           DC L:SetLETextByID-1                                   ;$3A added 19-Jan-91 DAL
0261 2DDA F3 34 02 00           DC L:GetLETextByID-1                                   ;$3B added 19-Jan-91 DAL
0262 2DDE              *** 6.0.1
0263 2DDE FD 3B 02 00           DC L:SetCtlValueByID-1                                 ;$3C added 15-Jul-92 DAL
0264 2DE2 2D 3C 02 00           DC L:GetCtlValueByID-1                                 ;$3D added 15-Jul-92 DAL
0265 2DE6 4D 3C 02 00           DC L:InvalOneCtlByID-1                                 ;$3E added 15-Jul-92 DAL
0266 2DEA B0 3C 02 00           DC L:HiliteCtlByID-1                                   ;$3F added 15-Jul-92 DAL
0267 2DEE              ENDFPT    
0268 2DEE                       ENDP 
0269 2DEE
0270 2DEE
0271 2DEE
0272 2DEE              CtlVersion PROC 
0273 2DEE
0274 2DEE A9 04 03              lda   #CtlVersionNum
0275 2DF1 83 07                 sta   7,s
0276 2DF3
0277 2DF3                       ENTRY QuickExit 
0278 2DF3              QuickExit  
0279 2DF3 A9 00 00              lda   #0
0280 2DF6 18                    clc   
0281 2DF7 6B                    rtl   
0282 2DF8
0283 2DF8                       ENDP 
0284 2DF8
0285 2DF8              *******************************************************************************
0286 2DF8              *
0287 2DF8              * CtlStartUp patch 4-Jan-91 DAL
0288 2DF8              *
0289 2DF8              * Modify the new default scroll bar color table based on the MasterSCB, and
0290 2DF8              * then go to the old CtlStartUp code in ROM.
0291 2DF8              *
0292 2DF8              *******************************************************************************
0293 2DF8              CtlStartUp proc export 
0294 2DF8                       import ComputeScrollColor,RemoveRefreshTask 
0295 2DF8
0296 2DF8              *** added 9-Dec-91 DAL
0297 2DF8 48                    pha   
0298 2DF9 5A                    phy   
0299 2DFA 20 31 3D              jsr   ComputeScrollColor
0300 2DFD 22 C1 3D 02           jsl   RemoveRefreshTask        ;3-Jun-92 DAL
0301 2E01 7A                    ply   
0302 2E02 68                    pla   
0303 2E03              *** end 9-Dec-91 DAL
0304 2E03 5C 00 91 FD  @toRom   jml   $fd9100                  ;original CtlStartUp entry point
0305 2E07
0306 2E07                       EndP 
0307 2E07
0308 2E07
0309 2E07              *******************************************************************************
0310 2E07              *
0311 2E07              * HiliteControl patch 9-Jan-91 DAL
0312 2E07              *
0313 2E07              * Call WaitUntil to wait 4 ticks since the last hilite, if we're hiliting
0314 2E07              * the most-recently-hilited control to 0.
0315 2E07              *
0316 2E07              *******************************************************************************
0317 2E07              HiliteControl proc export 
0318 2E07
0319 2E07 48                    pha   
0320 2E08 5A                    phy   
0321 2E09
0322 2E09              control  equ 11 
0323 2E09              newState equ control+4 
0324 2E09
0325 2E09 A2 00 00              ldx   #0                       ;anticipate using 0 for DelayAmount
0326 2E0C A3 0D                 lda   control+2,s
0327 2E0E CF 4A 31 02           cmp   >prevControl+2
0328 2E12 D0 0F                 bne   @different
0329 2E14 A3 0B                 lda   control,s
0330 2E16 CF 48 31 02           cmp   >prevControl
0331 2E1A D0 07                 bne   @different
0332 2E1C
0333 2E1C A3 0F                 lda   newState,s
0334 2E1E D0 03                 bne   @notZero
0335 2E20
0336 2E20 A2 40 00              ldx   #$0040                   ;delay amount
0337 2E23
0338 2E23              @notZero  
0339 2E23 A3 0D        @different lda   control+2,s
0340 2E25 8F 4A 31 02           sta   >prevControl+2
0341 2E29 A3 0B                 lda   control,s
0342 2E2B 8F 48 31 02           sta   >prevControl
0343 2E2F
0344 2E2F 48                    pha                            ;result space
0345 2E30 AF 4C 31 02           lda   >anchorTime
0346 2E34 48                    pha   
0347 2E35 DA                    phx                            ;delay amount
0348 2E36 A2 03 3A 22           _WaitUntil 
0349 2E3D 68                    pla   
0350 2E3E 8F 4C 31 02           sta   >anchorTime
0351 2E42
0352 2E42 7A           @toROM   ply   
0353 2E43 68                    pla   
0354 2E44 5C AA 94 FD           jml   $fd94aa                  ;HiliteControl entry in ROM 3
0355 2E48
0356 2E48 00 00 00 00  prevControl DC L:0
0357 2E4C 01 00        anchorTime DC W:1
0358 2E4E
0359 2E4E                       EndP 
0360 2E4E
0361 2E4E              *******************************************************************************
0362 2E4E              *
0363 2E4E              * CtlNewRes patch 4-Jan-91 DAL
0364 2E4E              *
0365 2E4E              * Modify the new default scroll bar color table based on the MasterSCB, and
0366 2E4E              * then go to the old CtlNewRes code in ROM.
0367 2E4E              *
0368 2E4E              *******************************************************************************
0369 2E4E              CtlNewRes proc export 
0370 2E4E                       import ComputeScrollColor 
0371 2E4E              *** added 9-Dec-91 DAL
0372 2E4E 5A                    phy   
0373 2E4F 48                    pha   
0374 2E50 20 31 3D              jsr   ComputeScrollColor
0375 2E53 68                    pla   
0376 2E54 7A                    ply   
0377 2E55              *** end 9-Dec-91 DAL
0378 2E55 5C D6 91 FD  @toRom   jml   $fd91d6                  ;original CtlNewRes entry point
0379 2E59
0380 2E59                       EndP 
0381 2E59
0382 2E59
0383 2E59              ****************************************************************
0384 2E59              *
0385 2E59              SendEventToCtl PROC EXPORT 
0386 2E59              *
0387 2E59              * This call is used to send events to the active control and to
0388 2E59              * any *visible* control including the active control.
0389 2E59              *
0390 2E59              * If the ActiveOnly flag is TRUE, then only the active control
0391 2E59              * gets the event.
0392 2E59              *
0393 2E59              * If the Active flag is FALSE, then the following takes place.
0394 2E59              * We perform a two part search for a control to take this event.
0395 2E59              * First, we look for controls that want key strokes that are 
0396 2E59              * not edit fields.  Each control is asked to take the event.
0397 2E59              * If none of these controls wants hte event, the active
0398 2E59              * edit field is asked to accept the event.
0399 2E59              *
0400 2E59              * If no control accepts the event, the output is FALSE.  If 
0401 2E59              * one of the controls accepts the event, the output is TRUE.
0402 2E59              * The handle of the accepting control is put into TaskDATA2 and
0403 2E59              * the ItemID is put in TaskDATA3.
0404 2E59              *
0405 2E59              *
0406 2E59              * Inputs:
0407 2E59              *                   ActiveOnlyFlag
0408 2E59              *                   WindowPtr
0409 2E59              *                   TaskRecPtr
0410 2E59              *
0411 2E59              * Outputs:
0412 2E59              *                   BooleanWord
0413 2E59              *
0414 2E59              * External Refs:
0415 2E59                       import CMStartup 
0416 2E59              ;	import UseThisWindPtr
0417 2E59              ;	import GetFirstSuperControl
0418 2E59              ;	import GetNextSuperControl
0419 2E59              ;	import FindActiveGuts
0420 2E59                       import CMDispatch 
0421 2E59              *
0422 2E59              * Entry Points:
0423 2E59              *                   none
0424 2E59              *
0425 2E59                       longa on                       ; mode
0426 2E59                       longi on 
0427 2E59              *
0428 2E59              * Change History
0429 2E59              *
0430 2E59              * 04 Nov 88         Steven Glass
0431 2E59              *
0432 2E59              * The control ID was returned in the wrong place and the
0433 2E59              * result from the DefPRoc was not returned at all.
0434 2E59              *
0435 2E59              * 17 Nov 88         Steven Glass
0436 2E59              *
0437 2E59              * Now use the specified window pointer instead of FrontWindow.
0438 2E59              *
0439 2E59              ****************************************************************
0440 2E59
0441 2E59              TaskRecPtr equ Inputs 
0442 2E59              WindowPtr equ TaskRecPtr+4 
0443 2E59              ActiveOnlyFlag equ WindowPtr+4 
0444 2E59              BooleanResult equ ActiveOnlyFlag+2 
0445 2E59
0446 2E59 20 87 32              jsr   CMStartup
0447 2E5C
0448 2E5C 64 58                 stz   BooleanResult            ; assume the worst
0449 2E5E
0450 2E5E A5 52                 lda   WindowPtr
0451 2E60 A6 54                 ldx   WindowPtr+2
0452 2E62              ;	jsr	UseThisWindPtr
0453 2E62 4B 62 06 00           jsrlFD $bbbe                   ;UseThisWindPtr is $FD/BBBE
0454 2E6D B0 5C                 bcs   exit
0455 2E6F
0456 2E6F A5 56                 lda   ActiveOnlyFlag
0457 2E71 D0 3C                 bne   TryActive
0458 2E73
0459 2E73              ;	jsr	GetFirstSuperControl
0460 2E73 4B 62 06 00           jsrlFD $BB9C                   ;GetFirstSuperControl is $FD/BB9C
0461 2E7E B0 4B                 bcs   exit
0462 2E80
0463 2E80 A0 3C 00     Loop     ldy   #NewCtlRecord.CtlMoreFlags ; if this one can be active, skip it for now
0464 2E83 B7 05                 lda   [<CtlPtr],y
0465 2E85 29 00 40              and   #FCtlCanBeActive
0466 2E88 D0 18                 bne   SkipThisOne
0467 2E8A
0468 2E8A B7 05                 lda   [<CtlPtr],y              ; if the control does not want events, then
0469 2E8C 29 00 20              and   #FCtlWantEvents          ; we skip it.
0470 2E8F F0 11                 beq   SkipThisOne
0471 2E91
0472 2E91              *** 16-Apr-91 DAL -- if the control is invisible, ignore it
0473 2E91 A0 10 00              ldy   #NewCtlRecord.ctlFlag
0474 2E94 B7 05                 lda   [<CtlPtr],y
0475 2E96 29 80 00              and   #$0080
0476 2E99 D0 07                 bne   SkipThisOne
0477 2E9B              *** end of 16-Apr-91 DAL
0478 2E9B
0479 2E9B 20 CF 31              jsr   SendIt
0480 2E9E
0481 2E9E A5 58                 lda   BooleanResult
0482 2EA0 D0 21                 bne   FinishUp
0483 2EA2              SkipThisOne  
0484 2EA2              ;	jsr	GetNextSuperControl
0485 2EA2 4B 62 06 00           jsrlFD $BBA6                   ;GetNextSuperControl is $FD/BBA6
0486 2EAD 90 D1                 bcc   Loop
0487 2EAF
0488 2EAF              TryActive  
0489 2EAF              ;	jsr	FindActiveGuts
0490 2EAF 4B 62 06 00           jsrlFD $BBE3                   ;FindActiveGuts is $FD/BBE3
0491 2EBA B0 0B                 bcs   Done
0492 2EBC
0493 2EBC 20 CF 31              jsr   SendIt
0494 2EBF A5 58                 lda   BooleanResult
0495 2EC1 F0 04                 beq   Done
0496 2EC3
0497 2EC3 5C 6C BA FD  FinishUp jml   $FDBA6C                  ;FinishUp in ROM
0498 2EC7 5C 94 BA FD  Done     jml   $FDBA94                  ;Done in ROM
0499 2ECB 5C 97 BA FD  Exit     jml   $FDBA97                  ;Exit in ROM
0500 2ECF
0501 2ECF 4B 62 06 00  SendIt   jsrlFD $BA9A                   ;SendIt is $FD/BA9A
0502 2EDA 60                    rts   
0503 2EDB
0504 2EDB                       ENDP 
0505 2EDB
0506 2EDB
0507 2EDB
0508 2EDB                       title 'MakeNextControlActive' 
0509 2EDB              ****************************************************************
0510 2EDB              *
0511 2EDB              MakeNextControlActive PROC EXPORT  
0512 2EDB              *
0513 2EDB              * This routine returns the handle to the newly activated
0514 2EDB              * super control.  A number of errors can be returned:
0515 2EDB              *
0516 2EDB              *   NOWIND_Err
0517 2EDB              *   NoCtlError
0518 2EDB              *   NoSuperCtlError
0519 2EDB              *   NoCtlToBeActiveError
0520 2EDB              *
0521 2EDB              * The newly activated control and the newly deactivated
0522 2EDB              * control are both sent activation messages so that
0523 2EDB              * they can change their display.
0524 2EDB              *
0525 2EDB              * This routine has the strange ability to return the
0526 2EDB              * same control as was originally active.  When this
0527 2EDB              * happens, no activation messages are sent.
0528 2EDB              *
0529 2EDB              * Note:  This call only works on the front window.
0530 2EDB              *
0531 2EDB              * Inputs:
0532 2EDB              *                   none
0533 2EDB              *
0534 2EDB              * Outputs:
0535 2EDB              *                   ControlHandle
0536 2EDB              *
0537 2EDB              * External Refs:
0538 2EDB                       import CMStartup 
0539 2EDB              ;	import FindActiveGuts2
0540 2EDB              ;	import GetFirstSuperControl
0541 2EDB              ;	import GetNextSuperControl
0542 2EDB              ;	import CallIt
0543 2EDB              ;	import CMDispatch
0544 2EDB
0545 2EDB              *
0546 2EDB              * Entry Points:
0547 2EDB              *                   none
0548 2EDB              *
0549 2EDB                       longa on                       ; mode
0550 2EDB                       longi on 
0551 2EDB              *
0552 2EDB              ****************************************************************
0553 2EDB              ResultH  equ Inputs 
0554 2EDB
0555 2EDB 20 87 32              jsr   CMStartup                ; link things in and start things up.
0556 2EDE
0557 2EDE 64 2D                 stz   work                     ; indicate that this is the first time in
0558 2EE0
0559 2EE0 64 4E                 stz   ResultH
0560 2EE2 64 50                 stz   ResultH+2
0561 2EE4
0562 2EE4              ;;;	jsr	FindActiveGuts2	; get first active control in  
0563 2EE4 4B 62 06 00           jsrlFD $BBDE                   ;(ROM 3)
0564 2EEF 90 0A                 bcc   GotActive                ; front window.
0565 2EF1
0566 2EF1 F4 00 00 F4           PushLong #0                    ; nothing active, put 0 on stack
0567 2EF7 5C 65 B9 FD           jml   >$fdb965                 ;TryFirst in ROM 3
0568 2EFB
0569 2EFB D4 03        GotActive pei   CtlHand+2               ; this is the control that needs to
0570 2EFD D4 01                 pei   CtlHand                  ; be made inactive
0571 2EFF
0572 2EFF A0 3C 00              ldy   #NewCtlRecord.CtlMoreFlags ; Clear current active bit
0573 2F02 B7 05                 lda   [<CtlPtr],y
0574 2F04 29 FF 7F              and   #($FFFF-FCtlActive)
0575 2F07 97 05                 sta   [<CtlPtr],y
0576 2F09
0577 2F09              *** added 22-Aug-91 DAL -- check for Command key to cycle backwards
0578 2F09 AF 25 C0 E0           lda   >$E0C025
0579 2F0D 29 80 00              and   #$0080
0580 2F10 F0 5F                 beq   @cycleForward
0581 2F12
0582 2F12              ; Find previous super control.
0583 2F12              ; <Work is the starting point.  If we get back there we're done.
0584 2F12              ; <Work+4 is the control we visited last, the one we want to make active.
0585 2F12 A5 03                 lda   <ctlHand+2
0586 2F14 A6 01                 ldx   <ctlHand
0587 2F16 85 2F                 sta   <work+2
0588 2F18 86 2D                 stx   <work
0589 2F1A
0590 2F1A A5 03        @keepAndSearch lda   <ctlHand+2         ;this one would be okay, so remember it
0591 2F1C A6 01                 ldx   <ctlHand
0592 2F1E 85 33                 sta   <work+6
0593 2F20 86 31                 stx   <work+4
0594 2F22
0595 2F22              @search   
0596 2F22              ;;;	jsr	GetNextSuperControl
0597 2F22 4B 62 06 00           jsrlFD $bba6                   ;FDBBA6 is GetNextSuperControl (ROM 3)
0598 2F2D 90 0B                 bcc   @gotOne
0599 2F2F              ;;;	jsr	GetFirstSuperControl
0600 2F2F 4B 62 06 00           jsrlFD $bb9c                   ;FDBB9C is GetFirstSuperControl (ROM 3)
0601 2F3A              @gotOne   
0602 2F3A A0 3C 00              ldy   #NewCtlRecord.CtlMoreFlags ; can this be active?
0603 2F3D B7 05                 lda   [<CtlPtr],y
0604 2F3F 29 00 40              and   #FCtlCanBeActive
0605 2F42 F0 DE                 beq   @search                  ; no, go on
0606 2F44
0607 2F44 A0 10 00              ldy   #NewCtlRecord.CtlFlag    ; check if its visible or not
0608 2F47 B7 05                 lda   [<CtlPtr],y
0609 2F49 89 80 00              bit   #$0080
0610 2F4C D0 D4                 bne   @search                  ; no, go on
0611 2F4E
0612 2F4E A5 03                 lda   <ctlHand+2               ;are we back where we started yet?
0613 2F50 A6 01                 ldx   <ctlHand
0614 2F52 C5 2F                 cmp   <work+2
0615 2F54 D0 C4                 bne   @keepAndSearch
0616 2F56 E4 2D                 cpx   <work
0617 2F58 D0 C0                 bne   @keepAndSearch
0618 2F5A A5 33                 lda   <work+6
0619 2F5C A6 31                 ldx   <work+4
0620 2F5E 85 03                 sta   <ctlHand+2
0621 2F60 86 01                 stx   <ctlHand
0622 2F62 A0 02 00              ldy   #2
0623 2F65 B7 01                 lda   [<ctlHand],y
0624 2F67 85 07                 sta   <ctlPtr+2
0625 2F69 A7 01                 lda   [<ctlHand]
0626 2F6B 85 05                 sta   <ctlPtr
0627 2F6D 5C 48 B9 FD           jml   >$fdb948                 ;useThisControl
0628 2F71
0629 2F71 5C 2F B9 FD  @cycleForward jml   >$fdb92f            ;ROM 3
0630 2F75
0631 2F75                       EndP 
0632 2F75
0633 2F75
0634 2F75
0635 2F75                       EJECT 
0636 2F75              *******************************************************************************
0637 2F75              *
0638 2F75              NewControl2 PROC 
0639 2F75              *
0640 2F75              * Description:      Patch to set the grafport to the owners port field.
0641 2F75              *
0642 2F75              *
0643 2F75              * Inputs:           Same as newcontrol2
0644 2F75              *
0645 2F75              * Outputs:          exit via ROM
0646 2F75              *
0647 2F75              * External Refs:
0648 2F75                       import CMStartup 
0649 2F75              *
0650 2F75              * Entry Points:
0651 2F75              *
0652 2F75              *******************************************************************************
0653 2F75              *
0654 2F75              * Variables used by NewControl2 and subroutines.
0655 2F75              *
0656 2F75              **********************************************************************
0657 2F75                       DSECT Inputs 
0658 2F75              InputRef long                           ;these are passed to us on the stack
0659 2F75              InputVerb word 
0660 2F75              TheWindow long 
0661 2F75              ResultH  long 
0662 2F75
0663 2F75
0664 2F75              TemplatePtr equ yRat                    ; this is not used at init time.
0665 2F75              *
0666 2F75              *
0667 2F75              *********************************************************************************
0668 2F75              BackToROM equ $FDB62E 
0669 2F75 20 87 32              jsr    CMStartup               ;link things in and start things up.
0670 2F78              ;
0671 2F78              ; Always set port to owner port! Mensch
0672 2F78              **	lda	TheWindow+2
0673 2F78              **	pha
0674 2F78              **	lda	TheWindow
0675 2F78              **	pha
0676 2F78 D4 56                 pei   TheWindow+2              ;changed lda/pha to pei  26-Nov-90 DAL
0677 2F7A D4 54                 pei   TheWindow                ;changed lda/pha to pei  26-Nov-90 DAL
0678 2F7C A2 04 1B 22           _SetPort 
0679 2F83
0680 2F83 5C 2E B6 FD           jml   >BackToROM
0681 2F87
0682 2F87                       EndP 
0683 2F87
0684 2F87              ;====================================================================
0685 2F87              ;          Do setup for tool call.
0686 2F87              ;
0687 2F87              ;   IN:    a+y = handle to data area.
0688 2F87              ;
0689 2F87              ;  OUT:    Carry clear if no error.
0690 2F87              ;          Carry set if null data pointer, y = error code.
0691 2F87              ;
0692 2F87              ;150=================================================================
0693 2F87              CMstartup proc EXPORT 
0694 2F87
0695 2F87 FA                    plx                            Get return address.
0696 2F88              ;
0697 2F88 0B                    phd                            Save caller's direct page.
0698 2F89 8B                    phb                            Save caller's data page.
0699 2F8A              ;
0700 2F8A 5A                    phy                            Save pointer to data area.
0701 2F8B 48                    pha   
0702 2F8C              ;
0703 2F8C DA                    phx   
0704 2F8D              ;
0705 2F8D 48                    pha                            Space for result.
0706 2F8E 48                    pha   
0707 2F8F A2 04 1C 22           _GetPort 
0708 2F96 68                    pla   
0709 2F97 7A                    ply   
0710 2F98 FA                    plx                            Get return addess.
0711 2F99 5A                    phy                            Save caller's port on stack.
0712 2F9A 48                    pha   
0713 2F9B              ;
0714 2F9B 3B                    tsc                            Allocate direct page on stack.
0715 2F9C 38                    sec   
0716 2F9D E9 3C 00              sbc   #DIRECTSIZE
0717 2FA0 1B                    tcs   
0718 2FA1 5B                    tcd   
0719 2FA2
0720 2FA2              ;
0721 2FA2 DA                    phx                            Put return address back on stack.
0722 2FA3              ;
0723 2FA3 A5 41                 lda   <data                    Valid data area pointer passed.
0724 2FA5 05 43                 ora   <data+2
0725 2FA7 18                    clc                            Clear error flag.
0726 2FA8 D0 10                 bne   exit
0727 2FAA              ;
0728 2FAA F4 02 10              pea   $1002                    Control Manager not started.
0729 2FAD              ;;;	pea	notInit>>16	Pass message.
0730 2FAD              ;;;	pea	notInit
0731 2FAD              *** 8-Dec-91 DAL
0732 2FAD F4 FD 00              pea   $00FD                    ;$FD/A048 is "Control Manager not initialized, error $"
0733 2FB0 F4 48 A0              pea   $A048
0734 2FB3              *** end 8-Dec-91
0735 2FB3 A2 03 15 22           _SysFailMgr 
0736 2FBA
0737 2FBA              *** 8-Dec-91 DAL -- This message is already in ROM, so let's save some bytes
0738 2FBA              ;;;notInit	DC.B 40
0739 2FBA              ;;;	DC.B 'Control Manager not initialized, error $'
0740 2FBA              *** end 8-Dec-91
0741 2FBA
0742 2FBA 60           exit     rts   
0743 2FBB
0744 2FBB                       EndP 
0745 2FBB
0746 2FBB              ****************************************************************
0747 2FBB              *
0748 2FBB              CtlBootInit PROC 
0749 2FBB              *
0750 2FBB              * This replaces the LLToolboxVector vector with an address of
0751 2FBB              * our own.
0752 2FBB              *
0753 2FBB              *
0754 2FBB              * Inputs:
0755 2FBB              *                   none
0756 2FBB              *
0757 2FBB              * Outputs:
0758 2FBB              *                   none
0759 2FBB              *
0760 2FBB              * External Refs:
0761 2FBB                       import MyLLToolboxVector 
0762 2FBB                       import OrigLLToolboxVector 
0763 2FBB              *
0764 2FBB              * Entry Points:
0765 2FBB              *                   none
0766 2FBB              *
0767 2FBB                       longa on                       ; mode
0768 2FBB                       longi on 
0769 2FBB              *
0770 2FBB              ****************************************************************
0771 2FBB
0772 2FBB
0773 2FBB AF BC 01 E1           lda   >LLToolboxVector
0774 2FBF 8F 60 33 02           sta   >OrigLLToolboxVector
0775 2FC3 AF BE 01 E1           lda   >LLToolboxVector+2
0776 2FC7 8F 62 33 02           sta   >OrigLLToolboxVector+2
0777 2FCB
0778 2FCB A9 DC 32              lda   #MyLLToolboxVector
0779 2FCE 8F BD 01 E1           sta   >LLToolboxVector+1
0780 2FD2 A9 32 02              lda   #>MyLLToolboxVector
0781 2FD5 8F BE 01 E1           sta   >LLToolboxVector+2
0782 2FD9
0783 2FD9 82 17 FE              brl   QuickExit
0784 2FDC
0785 2FDC                       ENDP 
0786 2FDC
0787 2FDC              ****************************************************************
0788 2FDC              *
0789 2FDC              MyLLToolboxVector PROC 
0790 2FDC              *
0791 2FDC              * This code looks at the message to be sent to the defProc.
0792 2FDC              * if the message is a dispose, we see if it is for a picture control
0793 2FDC              * and route if off differently.
0794 2FDC              *
0795 2FDC              * (Actually we check for a bunch of other stuff now, too.  --DAL)
0796 2FDC              *
0797 2FDC              *
0798 2FDC              * Inputs:
0799 2FDC              *                   a, x and y have sacred values
0800 2FDC              *                   code is on top of stack
0801 2FDC              *
0802 2FDC              * X = 0 for CMDispatch (dispatching a message to a control)
0803 2FDC              *           (Not everything for old controls goes through here?)
0804 2FDC              * X = 2 for WMActivate
0805 2FDC              * X = 4 for WMDeactivate
0806 2FDC              *
0807 2FDC              * Outputs:
0808 2FDC              *                   nothing may change unless we handle the
0809 2FDC              *                   dispatch.
0810 2FDC              *
0811 2FDC              * External Refs:
0812 2FDC              *                   none
0813 2FDC              *
0814 2FDC              * Entry Points:
0815 2FDC                       ENTRY OrigLLToolboxVector 
0816 2FDC              *
0817 2FDC                       longa on                       ; mode
0818 2FDC                       longi on 
0819 2FDC              *
0820 2FDC              ****************************************************************
0821 2FDC
0822 2FDC                       import StatTextProc            ;5-Apr-91 DAL
0823 2FDC                       import scroll_task_list        ;8-Dec-91 DAL
0824 2FDC
0825 2FDC 7C DF 32              jmp   (LLTable,x)
0826 2FDF
0827 2FDF E5 32        LLTable  DC W:isCMDispatch
0828 2FE1 60 33                 DC W:OrigLLToolboxVector
0829 2FE3 60 33                 DC W:OrigLLToolboxVector
0830 2FE5
0831 2FE5              isCMDispatch  
0832 2FE5
0833 2FE5              ;
0834 2FE5              ; Now check the message and see if it's the ones we want to trap.
0835 2FE5              ;
0836 2FE5 48                    pha                            ; save a-reg
0837 2FE6
0838 2FE6              *** added 5-Apr-91 DAL -- let's use the RAM-based static text control defproc
0839 2FE6 5A                    phy   
0840 2FE7 A0 16 00              ldy   #NewCtlRecord.ctlProc+2
0841 2FEA B7 05                 lda   [<ctlPtr],y
0842 2FEC C9 00 81              cmp   #$8100
0843 2FEF D0 0D                 bne   @notStatText
0844 2FF1
0845 2FF1 7A                    ply   
0846 2FF2 68                    pla   
0847 2FF3
0848 2FF3 7A                    ply                            ;Y now has the defproc message
0849 2FF4
0850 2FF4 A9 EB 3E              lda   #StatTextProc
0851 2FF7 A2 3E 02              ldx   #>StatTextProc
0852 2FFA
0853 2FFA              ;   IN:    y = task number.
0854 2FFA              ;          a = bytes 0 and 1 of defProc address.
0855 2FFA              ;          x = bytes 1 and 2 of defProc address.
0856 2FFA              ;          param = additional parameters.
0857 2FFA
0858 2FFA 5C 8C 9C FD           jml   >$fd9c8c                 ;customDispatch in ROM 3
0859 2FFE
0860 2FFE 7A           @notStatText ply   
0861 2FFF              *** end of 5-Apr-91 DAL
0862 2FFF
0863 2FFF              *** added 8-Dec-91 DAL -- use RAM copy of scroll_proc for (nearly) all Scroll Bar operations
0864 2FFF              *** (I believe everything other than the recSize messages vectors through here)
0865 2FFF 5A                    phy   
0866 3000 A0 16 00              ldy   #NewCtlRecord.ctlProc+2
0867 3003 B7 05                 lda   [<ctlPtr],y
0868 3005 0A                    asl   a
0869 3006 4A                    lsr   a                        ;clear bit 15
0870 3007 C9 00 06              cmp   #$0600                   ;$0600 or $8600 is Scroll Bar
0871 300A D0 32                 bne   @notScrollBar
0872 300C
0873 300C 7A                    ply   
0874 300D 68                    pla   
0875 300E
0876 300E 7A                    ply                            ;Y now has the defproc message
0877 300F
0878 300F A9 19 33              lda   #@my_scroll_proc
0879 3012 A2 33 02              ldx   #>@my_scroll_proc
0880 3015 5C 8C 9C FD           jml   >$fd9c8c                 ;customDispatch in ROM 3
0881 3019              *
0882 3019              * my_scroll_proc -- gets called just like a custom control
0883 3019              *
0884 3019              * stack:
0885 3019              * 14,s = space for result
0886 3019              * 12,s = message
0887 3019              *  8,s = ctlParam
0888 3019              *  4,s = theControlHandle
0889 3019              *  1,s = RTL
0890 3019              *
0891 3019 A3 0C        @my_scroll_proc lda   12,s
0892 301B C9 14 00              cmp   #ctlWinStateChange+1
0893 301E 90 06                 bcc   @goForIt
0894 3020 A9 00 00              lda   #0
0895 3023 AA                    tax   
0896 3024 80 05                 bra   @ouch
0897 3026
0898 3026 0A           @goForIt asl   a
0899 3027 AA                    tax   
0900 3028 FC 31 44              jsr   (scroll_task_list,x)     ;returns value in XA
0901 302B 83 0E        @ouch    sta   14,s
0902 302D 8A                    txa   
0903 302E 83 10                 sta   14+2,s
0904 3030 A3 02                 lda   2,s
0905 3032 83 0C                 sta   2+10,s
0906 3034 A3 01                 lda   1,s
0907 3036 83 0B                 sta   1+10,s                   ;copied RTL address
0908 3038 68                    pla   
0909 3039 68                    pla   
0910 303A 68                    pla   
0911 303B 68                    pla   
0912 303C 68                    pla                            ;stripped 10 bytes of input parameters
0913 303D 6B                    rtl   
0914 303E
0915 303E 7A           @notScrollBar ply   
0916 303F              *** end 8-Dec-91
0917 303F
0918 303F
0919 303F              *** removed 8-Dec-91 DAL
0920 303F              ;	lda	3,s	; check message being sent
0921 303F              ;	bne	LLnotDraw
0922 303F              ;* got Draw message
0923 303F              ;	phy
0924 303F              ;	ldy	#NewCtlRecord.ctlProc+2
0925 303F              ;	lda	[<ctlPtr],y
0926 303F              ;	and	#$7fff
0927 303F              ;	cmp	#$0600	;scroll bar?
0928 303F              ;	bne	@notScroll
0929 303F              ;
0930 303F              ;	ldy	#$24	;offset to color table
0931 303F              ;	lda	[<ctlPtr],y
0932 303F              ;	cmp	#$a4a7
0933 303F              ;	bne	@notScroll
0934 303F              ;	iny
0935 303F              ;	iny
0936 303F              ;	lda	[<ctlPtr],y
0937 303F              ;	cmp	#$00fd
0938 303F              ;	bne	@notScroll
0939 303F              ;	lda	#^NewScrollColorTable
0940 303F              ;	sta	[<ctlPtr],y
0941 303F              ;	dey
0942 303F              ;	dey
0943 303F              ;	lda	#NewScrollColorTable
0944 303F              ;	sta	[<ctlPtr],y
0945 303F              ;
0946 303F              ;@notScroll	ply
0947 303F              ;	brl	NotThisOne
0948 303F              ;
0949 303F              ;	EXPORT NewScrollColorTable
0950 303F              ;NewScrollColorTable	dc.w	$0000	Outline.
0951 303F              ;	dc.w	$00F0	Arrow when normal.
0952 303F              ;	dc.w	$00F0	Arrow when selected.
0953 303F              ;	dc.w	$00F0	Arrow's box interior.
0954 303F              ;	dc.w	$00F0	Thumber when normal.
0955 303F              ;	dc.w	$0000	Not used and should never be used.
0956 303F              ;*****	dc.w	$010F	Page region interior.
0957 303F              ;	dc.w	$00C0	Page region interior. (Gets stored over at CtlStartUp/CtlNewRes time)
0958 303F              ;	dc.w	$00F0	Interior color of inactive bar.
0959 303F              ;
0960 303F              ;
0961 303F              ;LLnotDraw	cmp	#newValue
0962 303F              ;	bne	LLnotNewValue
0963 303F              ;;
0964 303F              ;; 4-Jan-91 DAL
0965 303F              ;;
0966 303F              ;; Max out the scrolling speed to a fixed amount of time.
0967 303F              ;; If it hasn't been minScrollTime since the last time we
0968 303F              ;; moved the thumb, wait until it has.
0969 303F              ;;
0970 303F              ;	pha
0971 303F              ;	phy
0972 303F              ;	phx
0973 303F              ;	ldy	#NewCtlRecord.ctlProc+2
0974 303F              ;	lda	[<ctlPtr],y
0975 303F              ;	and	#$7fff
0976 303F              ;	cmp	#$0600	;scroll bar?
0977 303F              ;	bne	@notScroll
0978 303F              ;
0979 303F              ;	pha		;space for result
0980 303F              ;	lda	>lastScrollTime
0981 303F              ;	pha
0982 303F              ;	pea	MinScrollDelay
0983 303F              ;	_WaitUntil
0984 303F              ;	pla
0985 303F              ;	sta	>lastScrollTime
0986 303F              ;
0987 303F              ;@notScroll	plx
0988 303F              ;	ply
0989 303F              ;	pla
0990 303F              ;	brl	NotThisOne
0991 303F              ;
0992 303F              ;lastScrollTime	dc.w	0
0993 303F              *** end of removed 8-Dec-91
0994 303F
0995 303F              LLnotNewValue  
0996 303F              ; end of 4-Jan-91 DAL
0997 303F C9 04 00              cmp   #dispCntl                ; Is it the picture control bug?
0998 3042 F0 02                 beq   GotDispMessage
0999 3044
1000 3044 80 19                 bra   NotThisOne               ;GAWD, I'M STUPID!  THIS WAS MISSING ON 6.0D31.
1001 3046
1002 3046              ;;; dead code 5-Apr-91 DAL
1003 3046              ;	cmp	#initCntl	; Is it the StatText bug?
1004 3046              ;	bne	NotThisOne
1005 3046              ;
1006 3046              ;* GotInitMessage
1007 3046              ;	phy
1008 3046              ;	ldy	#NewCtlRecord.ctlProc+2
1009 3046              ;	lda	[ctlPtr],y
1010 3046              ;	bpl	NotRightControl	; not super control, so not static text control
1011 3046              ;	
1012 3046              ;	cmp	#^StatTextControl
1013 3046              ;	bne	NotRightControl
1014 3046              ;	dey
1015 3046              ;	dey
1016 3046              ;	lda	[ctlPtr],y
1017 3046              ;	bne	NotRightControl
1018 3046              ;	lda	#1
1019 3046              ;	sta	5,s	; this is now our new message code to be used later
1020 3046              ;	brl	GotControl
1021 3046
1022 3046              ;
1023 3046              ; This is it.  See if the defProc is the picture defProc.
1024 3046              ;
1025 3046 5A           GotDispMessage phy   
1026 3047 A0 16 00              ldy   #NewCtlRecord.ctlProc+2
1027 304A B7 05                 lda   [ctlPtr],y
1028 304C 10 10                 bpl   NotRightControl          ; not picture control
1029 304E
1030 304E C9 00 8D              cmp   #^PictureControl
1031 3051 D0 0B                 bne   NotRightControl
1032 3053 88                    dey   
1033 3054 88                    dey   
1034 3055 B7 05                 lda   [ctlPtr],y
1035 3057 D0 05                 bne   NotRightControl
1036 3059 83 05                 sta   5,s                      ; this is now our new message code to be used later (zero)
1037 305B 82 06 00              brl   GotControl
1038 305E
1039 305E              NotRightControl  
1040 305E 7A                    ply   
1041 305F
1042 305F 68           NotThisOne pla   
1043 3060
1044 3060 00 00 00 00  OrigLLToolboxVector DC L:0
1045 3064
1046 3064
1047 3064              ;
1048 3064              ; It's a control/message that we need to patch
1049 3064              ;
1050 3064 7A           GotControl ply   
1051 3065 68                    pla   
1052 3066
1053 3066 FA                    plx   
1054 3067
1055 3067 D4 03                 pei   <Ctlhand+2               Save current handle of control.
1056 3069 D4 01                 pei   <Ctlhand
1057 306B              ;
1058 306B 48                    pha                            Space for return value.
1059 306C 48                    pha   
1060 306D              ;
1061 306D DA                    phx                            Pass task number(which has been changed above).
1062 306E              ;
1063 306E D4 2B                 pei   <param+2                 Pass additional parameters.
1064 3070 D4 29                 pei   <param
1065 3072              ;
1066 3072 D4 03                 pei   <Ctlhand+2               Pass control's handle.
1067 3074 D4 01                 pei   <Ctlhand
1068 3076              ;
1069 3076 22 7E 33 02           jsl   DoMoreCommon
1070 307A 5C 9F 9C FD           jml   $FD9C9F                  ; back into ROM.
1071 307E
1072 307E
1073 307E              DoMoreCommon  
1074 307E 48                    pha                            ; push on some room for 'TheCtlPtr'
1075 307F 48                    pha   
1076 3080
1077 3080 8B                    phb                            ; save the Data Bank register
1078 3081 0B                    phd                            ; save the Direct Page register
1079 3082
1080 3082 4B                    phk                            ; switch data bank to program bank
1081 3083 AB                    plb   
1082 3084 3B                    tsc                            ; switch Direct Page into stack
1083 3085 5B                    tcd   
1084 3086
1085 3086 A7 0B                 lda   [<theCtlHandle]          ; deref control handle
1086 3088 85 04                 sta   <TheCtlPtr
1087 308A A0 02 00              ldy   #2
1088 308D B7 0B                 lda   [<theCtlHandle],y
1089 308F 85 06                 sta   <TheCtlPtr+2
1090 3091              ;
1091 3091              ; ----- Now the stack is set up just like the defproc like it ---------------
1092 3091              ;
1093 3091 A5 13                 lda   <ctlCode                 ; the ctlCode now is the offset to the table
1094 3093 0A                    asl   a                        ; of the bug we want to fix
1095 3094 AA                    tax   
1096 3095 FC AD 33              jsr   (PatchTable,x)
1097 3098                        
1098 3098 85 15                 sta   <ReturnValue             ; save the return value
1099 309A 86 17                 stx   <ReturnValue+2
1100 309C
1101 309C              ;
1102 309C              ; The Return Value has been stored on the stack, and it is time for us to
1103 309C              ; return back to the Control Manager. Before we do so, however, we must
1104 309C              ; remove the parameters that were passed to us on the stack. We do this
1105 309C              ; by moving the RTL address up just below the Return Value, getting the
1106 309C              ; stack pointer, and adding an amount to it so that we point to where
1107 309C              ; the RTL address has been moved to. We can then simply RTL back to the
1108 309C              ; Control Manager, and it will pick up the Return Value right off of the
1109 309C              ; stack!
1110 309C              ;
1111 309C A5 08                 lda   <RtnAddr                 ; move the return address up
1112 309E 85 12                 sta   <ReturnValue-3
1113 30A0 A5 09                 lda   <RtnAddr+1
1114 30A2 85 13                 sta   <ReturnValue-2
1115 30A4
1116 30A4 3B                    tsc                            ; Get the stack pointer
1117 30A5
1118 30A5 2B                    pld                            ; restore caller's Data Bank and
1119 30A6 AB                    plb                            ; Direct Page registers
1120 30A7
1121 30A7 18                    clc                            ; Adjust the stack pointer to point to
1122 30A8 69 11 00              adc   #ReturnValue-4           ; the new location of the RTL address.
1123 30AB 1B                    tcs                            ; Put the stack pointer back.
1124 30AC
1125 30AC 6B                    rtl                            ; back to the caller
1126 30AD
1127 30AD AF 33        PatchTable DC W:PictBug                 ; picture control bug, not disposes picture resources
1128 30AF              ; dead 5-Apr-91 DAL	dc.w	StatTextBug	; static text bug, justification field not looked at
1129 30AF
1130 30AF              ;================================================================
1131 30AF              ;
1132 30AF              ; This routine fixes the picture control bug in TenSpeed ROMs.
1133 30AF              ; Any picture loaded from a resource was not being released.
1134 30AF              ;
1135 30AF              ;================================================================
1136 30AF              PictBug   
1137 30AF                       IMPORT do_dispose 
1138 30AF
1139 30AF 20 81 43              jsr   do_dispose
1140 30B2
1141 30B2 60                    rts   
1142 30B3
1143 30B3              ;;; dead code 5-Apr-91 DAL
1144 30B3              ;;================================================================
1145 30B3              ;;
1146 30B3              ;; This routine fixes the static text control bug in TenSpeed ROMs.
1147 30B3              ;; The init routine did not copy the justification field into the
1148 30B3              ;; control record. BRC #51450
1149 30B3              ;;
1150 30B3              ;;================================================================
1151 30B3              ;StatTextBug
1152 30B3              ;	IMPORT do_StatInit
1153 30B3              ;
1154 30B3              ;	jsr	do_StatInit
1155 30B3              ;
1156 30B3              ;	rts
1157 30B3
1158 30B3
1159 30B3                       ENDP 
1160 30B3
1161 30B3
1162 30B3              ****************************************************************
1163 30B3              *
1164 30B3              PushCtlData PROC EXPORT 
1165 30B3              *
1166 30B3              * Utility routine used by do_dispose.
1167 30B3              *
1168 30B3              *
1169 30B3              * Inputs:
1170 30B3              *                   none
1171 30B3              *
1172 30B3              * Outputs:
1173 30B3              *                   none
1174 30B3              *
1175 30B3              * External Refs:
1176 30B3              *                   none
1177 30B3              *
1178 30B3              * Entry Points:
1179 30B3              *                   none
1180 30B3              *
1181 30B3                       longa on                       ; mode
1182 30B3                       longi on 
1183 30B3              *
1184 30B3              ****************************************************************
1185 30B3
1186 30B3 FA                    plx   
1187 30B4 A0 1E 00              ldy   #NewCtlRecord.ctlData+2
1188 30B7 B7 04                 lda   [TheCtlPtr],y
1189 30B9 48                    pha   
1190 30BA 88                    dey   
1191 30BB 88                    dey   
1192 30BC B7 04                 lda   [TheCtlPtr],y
1193 30BE 48                    pha   
1194 30BF DA                    phx   
1195 30C0 60                    rts   
1196 30C1
1197 30C1                       ENDP 
1198 30C1
1199 30C1                       END   
